﻿#pragma once

namespace RTCam {

// The main application window
class AppWindow final
{
public:
	AppWindow();
	~AppWindow();

	// Register the class and create the window.
	HRESULT InitWindow(_In_ const HINSTANCE hInstance, const int nCmdShow);

	const HWND		GetHWND() { return m_windowHandle; }
	DirectX::XMINT2 GetClientSize();

	void OnResize();

private:
	bool		m_initialized;
	HINSTANCE	m_instanceHandle;
	HWND		m_windowHandle;

	DirectX::XMINT2 m_clientSize;	// Client area dimensions
};

} // end namespace